# -*- coding: utf-8 -*-
"""
Created on Thu Jul  6 14:52:42 2017

@author: joeridebruijck
"""

import sys
from PyQt5.QtWidgets import QApplication, QWidget, QPushButton, QSlider, QVBoxLayout, QHBoxLayout, QLineEdit, QLabel, QFileDialog
from PyQt5.QtCore import Qt
import numpy as np

class Window(QWidget):
    
    def __init__(self):
        super().__init__()
        
        self.init_ui()
        
    def init_ui(self):
        self.file_btn = QPushButton('Select File')
        
        self.file_le = QLineEdit()
        self.file_le.setText('electromigration.t91')
        
        self.volt_le = QLineEdit()
        self.volt_le.setText('0.00')
        
        self.diff_le = QLineEdit()
        self.diff_le.setText('0.001')
        
        self.trgt_lb = QLabel('Target R (kOhm)')
        self.glb_del_lb = QLabel('Global delay (us)')
        self.adc_del_lb = QLabel('ADC delay (us)')
        self.volt_lb = QLabel('Bias voltage (V)')
        self.diff_lb = QLabel('Percentage change in resistance')
        
        self.trgt_le = QLineEdit()
        self.trgt_le.setText('3')
        self.glb_del_le = QLineEdit()
        self.glb_del_le.setText('50')
        self.adc_del_le = QLineEdit()
        self.adc_del_le.setText('1')
        
        # Voltage slider
        self.volt_sld = QSlider(Qt.Horizontal)
        self.volt_sld.setMinimum(0)
        self.volt_sld.setMaximum(100)
        self.volt_sld.setValue(0)
        self.volt_sld.setTickInterval(10)
        self.volt_sld.setTickPosition(QSlider.TicksBelow)
        
        # Differential slider
        self.diff_sld = QSlider(Qt.Horizontal)
        self.diff_sld.setMinimum(1)
        self.diff_sld.setMaximum(500)
        self.diff_sld.setValue(1)
        self.diff_sld.setTickInterval(50)
        self.diff_sld.setTickPosition(QSlider.TicksBelow)
        
        h_file = QHBoxLayout()
        h_file.addWidget(self.file_btn, 1)
        h_file.addWidget(self.file_le, 3)
        
        h_lbs = QHBoxLayout()
        h_lbs.addWidget(self.trgt_lb, 1)
        h_lbs.addWidget(self.glb_del_lb, 1)
        h_lbs.addWidget(self.adc_del_lb, 1)
        
        h_les = QHBoxLayout()
        h_les.addWidget(self.trgt_le, 1)
        h_les.addWidget(self.glb_del_le, 1)
        h_les.addWidget(self.adc_del_le, 1)
        
        h_volt = QHBoxLayout()
        h_volt.addWidget(self.volt_sld, 5)
        h_volt.addWidget(self.volt_le, 1)
        
        h_diff = QHBoxLayout()
        h_diff.addWidget(self.diff_sld, 5)
        h_diff.addWidget(self.diff_le, 1)
        
        v_ctrl = QVBoxLayout()
        v_ctrl.addLayout(h_file)
        v_ctrl.addLayout(h_lbs)
        v_ctrl.addLayout(h_les)
        v_ctrl.addWidget(self.volt_lb)
        v_ctrl.addLayout(h_volt)
        v_ctrl.addWidget(self.diff_lb)
        v_ctrl.addLayout(h_diff)
        
        self.setLayout(v_ctrl)
        
        self.setWindowTitle('Electromigration')
        
        self.file_btn.clicked.connect(self.file_btn_clk)
        
        self.volt_sld.valueChanged.connect(self.volt_change)
        self.diff_sld.valueChanged.connect(self.diff_change)
        
        self.show()
        
    def file_btn_clk(self):
        filename = QFileDialog.getOpenFileName(self, 'Open .t91 File')
        print(filename[0])
        self.file_le.setText(filename[0])
        
    def volt_change(self):
        volt_value = '%.2f' % (self.volt_sld.value()*0.02)
        self.volt_le.setText(volt_value)
        
    def diff_change(self):
        diff_value = '%.3f' % (self.diff_sld.value()*0.001)
        self.diff_le.setText(diff_value)

    
app = QApplication(sys.argv)    
w = Window()  
sys.exit(app.exec_())